<?php

namespace App\Form;

use App\Entity\SqrData;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class SqrDataType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('A')
            ->add('B')
            ->add('C')
            ->add('sqr_code')
            ->add('approot')
            ->add('NIU')
            ->add('proprietaire')
            ->add('document')
            ->add('statut')
            ->add('date_creation')
            ->add('date_modification')
            ->add('donnees')
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => SqrData::class,
        ]);
    }
}
